<?php
include "db_connection.php";

// Query to fetch categories from the category table
$sql = "SELECT cat_id, cat_name,cat_image FROM category";
$result = mysqli_query($conn, $sql);

// Check if there are categories
if (mysqli_num_rows($result) > 0) {
    // Output section start
    echo '<section class="section-adj" id="item-config-class-below-contetnt">
        <div class="container-fluid px-2 py-2">
            <div class="row">';
            $categoryData = [];
            // Fetch all categories into an array

    // Loop through each category and generate HTML
    while ($row = mysqli_fetch_assoc($result)) {
        $categoryId = $row['cat_id'];
        $categoryName = $row['cat_name'];
        $categoryImage = $row['cat_image'];
        
        $categoryData[] = [
            'id' => $categoryId,
            'name' => $categoryName,
            'image'=>$categoryImage
        ];
        echo '<div class="col-md-6">
                <div class="d-flex mb-4">
                    <div class="p-2" style="border-radius: 20px; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px 0px; width: 100%;">
                        <div class="d-flex">
                            <div class="p-3 mr-3"><img src="' . $categoryImage . '" class="img-thumb" style="width:50px"/></div>
                            <div class="pt-4 pb-4 width-adj">
                                <p class="text-color-545454">' . $categoryName . '</p>
                            </div>
                            <div class="pt-4 pb-4 mr-3">
                                <button class="btn-black-bg mr-2 edit-details-btn" data-toggle="modal" data-target="#classModal" data-category-id="'.$categoryId.'">Edit Details</button>
                            </div>
                            <div class="pt-4 pb-4 mt-1 mr-5">
                                <a id="sub-class-btn_'.$categoryId.'" onclick="toggleSubClass('.$categoryId.')"> <img src="plugins/img/chevron-down.svg"/></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
    }
    echo '</div></div></section>';
        // Subclass container
        echo '<section class="item-configuration-subcalss" id="item-config-class-below-contetnt-application-section" style="padding:10px 10px;">';
            
        foreach ($categoryData as $category) {
            echo '<div class="accordion subclassContainer_'.$category['id'].'" style="display:none">'; 
            
            // Query to fetch subcategories for the current category
            $sub_sql = "SELECT sub_id,sub_name,sub_image,sub_description FROM sub_category WHERE cat_id = '".$category['name']."'";
        
            $sub_result = mysqli_query($conn, $sub_sql);
     
        
    if (mysqli_num_rows($sub_result) > 0) {
        while($sub_row = mysqli_fetch_assoc($sub_result)) {
             
                          echo '<div class="card">
                                <div class="card-header d-flex edit-product-item-up" style="cursor: pointer;">
                                  <div class="mr-3"><img src="'.$sub_row['sub_image'].'" style="width: 40px; height: 40px !important; border-radius: 50%;" /></div>
                                  <div class="pt-2">
                                    <p class="text-color-4C4C4C fw-500 fw-500">'.$sub_row['sub_name'].'</p>
                                  </div>
                                  <div class="pt-1 ml-auto">
                                    <button class="btn-black-bg mr-2 app-edit-details-btn edit-subclass-btn" data-toggle="modal" data-target="#subclassModal" data-subcategory-id="'.$sub_row['sub_id'].'">Edit Details</button>
                                    <span class="accicon ml-5" data-toggle="collapse" data-target="#collapseOne_'.$sub_row['sub_id'].'" aria-expanded="false" aria-controls="collapseOne_'.$category['id'].'">
                                      <i class="fa fa-angle-down rotate-icon"></i>
                                    </span>
                                  </div>
                                </div>
                            <div id="collapseOne_'.$sub_row['sub_id'].'" class="collapse" data-parent="#accordionClass" style="">
                                <div class="card-body pl-5">
                                  <div class="pt-1 mr-5 text-right"></div>
                                    <div class="wrapper">
                                      <div class="scrollbar">
                                          <div class="force-overflow">
                                              <h3>'.$sub_row['sub_name'].'</h3>';
                 // $product_sql = "SELECT name, sku, available, sellingPrice FROM products WHERE subCategory = '".$sub_row['sub_name']."'";
                 $product_sql = "SELECT p.name as name, p.sku as sku, p.available as available, p.basePrice as basePrice, i.name as thumbnail 
                FROM products p 
              LEFT  JOIN images i ON p.id = i.product_id 
                WHERE p.subCategory = '".$sub_row['sub_name']."'";
 
                 $product_result = mysqli_query($conn, $product_sql);
                  if (mysqli_num_rows($product_result) > 0) {
                      echo '<table class="datatable ml-5" style="width:100%">
                                                  <thead>
                                                      <tr>
                                                          <th class="p-2 text-color-4C4C4C fw-500">Thumbnails</th>
                                                          <th class="p-2 text-color-4C4C4C fw-500">Product Name</th>
                                                          <th class="p-2 text-color-4C4C4C fw-500">SKU</th>
                                                          <th class="p-2 text-color-4C4C4C fw-500">Stock</th>
                                                          <th class="p-2 text-color-4C4C4C fw-500 pr-5">Price</th>
                                                      </tr>
                                                  </thead>
                                                  <tbody>';
                      while ($product_row = mysqli_fetch_assoc($product_result)) {
                          echo '<tr>
                                  <td class="p-2"><img src="uploads/'.$product_row['thumbnail'].'" style="width: 50px;"/></td>
                                  <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['name'].'</td>
                                  <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['sku'].'</td>
                                  <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['available'].'</td>
                                  <td class="p-2 text-color-4C4C4C fw-500">'.$product_row['basePrice'].'</td>
                                </tr>';
                      }
                      echo '</tbody></table>';
                  } else {
                      echo '<p>No products found for this subcategory.</p>';
                  }
                  echo ' </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
                     ';
                          
            }
           
        } else {
            echo '<p>No subcategories found.</p>';
        }
        echo '</div>';    
    
}
echo '</section>'; 
} else {
    // No categories found
    echo 'No categories found.';
}

// Close the database connection
mysqli_close($conn);
?> <script>
    function toggleSubClass(catId) {
        var subclassContainers = document.getElementsByClassName('subclassContainer_' + catId);
        for (var i = 0; i < subclassContainers.length; i++) {
            var subclassContainer = subclassContainers[i];
            if (subclassContainer.style.display === "none") {
                subclassContainer.style.display = "block";
                $("#item-config-class-below-contetnt").hide();
            } else {
                subclassContainer.style.display = "none";
            }
        }
    }
    
      
                    // $("#item-config-class-below-contetnt-application-section").show();
                    // $("#item-config-class-below-contetnt").hide();
             
    
</script>