$(document).ready(function() {
    var dealerId = localStorage.getItem("dealerId");
    var username = localStorage.getItem("username");
    $('#user-name').text(username);
    if (dealerId && username) {

        $.ajax({
            url: `http://ctframework.cnetric.com:1880/dashboard_summary/${dealerId}`,
            type: "GET",
            success: function(data) {
                console.log(data);
                if (data.responseCode == 200) {
                    $('.order-pickup-num').html(data.picking_orders);
                    $('.order-shipping-num').text(data.shipping_orders);
                    $('.sales-num').text(data.total_sales);
                    $('.product-num').text(data.total_products);
                } else {
                    $.notify("Summary data is not available", { className: 'error', showDuration: 200, autoHideDelay: 6000, position: 'right bottom' });
                }
            }
        });
    } else {
        window.location.replace("login.html");
    }
    dealer_info(dealerId);
    var dealerName = localStorage.getItem("dealername");
    $('#dealer-name').text(dealerName);


    /**
     * To get Dealer details
     * @param {*} dealerId 
     */
    function dealer_info(dealerId) {
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/get-dealer_details/${dealerId}`,
            type: "GET",
            success: function(data) {
                if (data.length) {
                    var data = data[0];
                    if (data.dealer_Name) {
                        localStorage.setItem("dealername", data.dealer_Name);
                    } else {
                        localStorage.setItem("dealername", "Unknown");
                    }
                } else {
                    localStorage.setItem("dealername", "Unknown");
                }
            }
        });
    }

});

$(".logout").click(function() {
    localStorage.removeItem('dealerId');
    localStorage.removeItem('username');
    localStorage.removeItem('dealername');
});