<?php
include "db_connection.php";

$response = array(); // Create a new array to store the response data
if(isset($_GET['subcategoryId'])) {
    $subcategoryId = $_GET['subcategoryId'];   
// Query to fetch subcategories from the subcategory table
$sql = "SELECT sub_id, sub_name,sub_image,sub_description FROM sub_category WHERE sub_id = $subcategoryId";
$result = mysqli_query($conn, $sql);

// Check if there are subcategories
if (mysqli_num_rows($result) > 0) {
    // Fetch all subcategories into an array
    $subcategoryData = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $subId = $row['sub_id'];
        $subName = $row['sub_name'];
        $subDescription = $row['sub_description'];
        $subImage = $row['sub_image'];        
        $subcategoryData[] = [
            'id' => $subId,
            'name' => $subName,
            'description' => $subDescription,
            'image' => $subImage
        ];
    }

    $response['success'] = true;
    $response['data'] = $subcategoryData;
} else {
    // No subcategories found
    $response['success'] = false;
    $response['message'] = "No subcategories found.";
}
} else {
    $response['success'] = false;
    $response['message'] = "Invalid request";
 }
// Close the database connection
mysqli_close($conn);

// Send the JSON response back to the client
header('Content-Type: application/json');
echo json_encode($response);
?>
