<?php
include "db_connection.php";

// Fetch necessary counts from the database
$query_categories = "SELECT COUNT(*) AS category_count FROM category";
$result_categories = mysqli_query($conn, $query_categories);
$row_categories = mysqli_fetch_assoc($result_categories);
$category_count = $row_categories['category_count'];

$query_subcategories = "SELECT COUNT(*) AS subcategory_count FROM sub_category";
$result_subcategories = mysqli_query($conn, $query_subcategories);
$row_subcategories = mysqli_fetch_assoc($result_subcategories);
$subcategory_count = $row_subcategories['subcategory_count'];

// Calculate total count
$total_count = $category_count + $subcategory_count;

$query_products = "SELECT COUNT(*) AS product_count FROM products";
$result_products = mysqli_query($conn, $query_products);
$row_products = mysqli_fetch_assoc($result_products);
$product_count = $row_products['product_count'];

$query_low_stock = "SELECT COUNT(*) AS low_stock_count FROM products WHERE available < 10";
$result_low_stock = mysqli_query($conn, $query_low_stock);
$row_low_stock = mysqli_fetch_assoc($result_low_stock);
$low_stock_count = $row_low_stock['low_stock_count'];

$query_out_of_stock = "SELECT COUNT(*) AS out_of_stock_count FROM products WHERE available = 0";
$result_out_of_stock = mysqli_query($conn, $query_out_of_stock);
$row_out_of_stock = mysqli_fetch_assoc($result_out_of_stock);
$out_of_stock_count = $row_out_of_stock['out_of_stock_count'];


$response = array(
    'category_count' => $total_count,
    'product_count' => $product_count,
    'low_stock_count' => $low_stock_count,
    'out_of_stock_count' => $out_of_stock_count
);


echo json_encode($response);
?>
