<?php
include "db_connection.php";

// Query to fetch brands from the brands table
$sql = "SELECT id, brand_name FROM brand";
$result = mysqli_query($conn, $sql);

// Check if there are brands
if (mysqli_num_rows($result) > 0) {
    // Output section start
    echo '<section class="section-adj" id="accordionBrand">
        <div class="container-fluid px-2 py-2">
            <div class="row">';
    
    // Loop through each brand and generate HTML
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<div class="col-md-6">
                <div class="card">
                    <div class="card-header collapsed edit-product-item-up" data-toggle="collapse" data-target="#collapseTwo_' . $row['id'] . '" aria-expanded="false">
                        <div class="d-flex pt-0 mt-0">
                            <div class="mr-3"><img src="plugins/img/ellipse3.png" style="width:40px;height:40px !important;border-radius: 50%;" /></div>
                            <div class="pt-2">
                                <p class="text-color-4C4C4C fw-500">' . $row['brand_name'] . '</p>
                            </div>
                            <div class="pt-1 ml-auto">
                                <span class="accicon ml-5"><i class="fa fa-angle-down rotate-icon"></i></span>
                            </div>
                        </div>
                    </div>
                    <div id="collapseTwo_' . $row['id'] . '" class="collapse" data-parent="#accordionBrand">
                        <div class="card-body pl-5">
                            <!-- Additional details can be added here -->
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    // Output section end
    echo '</div>
        </div>
    </section>';
} else {
    // No brands found
    echo 'No brands found.';
}

// Close the database connection
mysqli_close($conn);
?>
