<?php
include "db_connection.php";

// Query to fetch categories from the category table
$sql = "SELECT cat_id, cat_name FROM category";
$result = mysqli_query($conn, $sql);

// Check if there are categories
if (mysqli_num_rows($result) > 0) {
    // Output section start
    echo '<section class="section-adj" id="item-config-class-below-contetnt">
        <div class="container-fluid px-2 py-2">
            <div class="row">';
    
    // Loop through each category and generate HTML
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<div class="col-md-6">
                <div class="d-flex mb-4">
                    <div class="p-2" style="border-radius: 20px; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px 0px; width: 100%;">
                        <div class="d-flex">
                            <div class="p-3 mr-3"><img src="plugins/img/Rectangleimg.png" class="img-thumb" style="width:50px"/></div>
                            <div class="pt-4 pb-4 width-adj">
                                <p class="text-color-545454">' . $row['cat_name'] . '</p>
                            </div>
                            <div class="pt-4 pb-4 mr-3">
                                <button class="btn-black-bg mr-2" data-toggle="modal" data-target="#classModal">Edit Details</button>
                            </div>
                            <div class="pt-4 pb-4 mt-1 mr-5">
                                <a id="sub-class-btn">
                                    <img src="plugins/img/chevron-down.svg"/>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    // Output section end
    echo '</div>
        </div>
    </section>';
} else {
    // No categories found
    echo 'No categories found.';
}

// Close the database connection
mysqli_close($conn);
?>
