$(document).ready(function() {
    var dealerId = localStorage.getItem("dealerId");
    var username = localStorage.getItem("username");
    var dealerName = localStorage.getItem("dealername");
    $('#dealer-name').text(dealerName);
    const params = new URLSearchParams(window.location.search);
    const orderId = params.get("order_id");
    console.log(orderId);
    var option;
    var order_total;

    if (dealerId && username && orderId) {
        get_order_details();
    } else {
        window.location.replace("login.html");
    }
    
    function get_order_details() {
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/get-dealer_order/${orderId}/${dealerId}`,
            type: "GET",
            success: function(data) {
                console.log(data);
                order_total=data[0].order_total;
                console.log(JSON.parse(data[0].order_data));

                if (data[0].fulfill_type == 'pick_from_dealer') {
                    $(".ready_for_pickup").show();
                    $(".updatebtn").addClass('Open');
                }
                if (data.length) {
                    var data = data[0];
                    var orders = JSON.parse(data.order_data);
                    var order_shippingAddress= orders.shippingAddress;
                    var order_lineItems= orders.lineItems;
                    var order_totalPrice= orders.totalPrice;
        
                    let customerTxt = `<li class="list-group-item">Name <span>${data.name}</span></li>
                    <li class="list-group-item">Email <span>${data.email}</span></li>
                    <li class="list-group-item">Mobile <span>${data.mobile}</span></li>`;
                    $('.customer-details-list').html(customerTxt);

                    let orderTxt = `<li class="list-group-item">Order Number <span>${data.order_id}</span></li>
                    <li class="list-group-item">Dealer Order No <span>${data.dealer_order_no}</span></li>
                   
                    <li class="list-group-item">Date <span>${data.created_date}</span></li>`;
                    $('.order-details-list').html(orderTxt);

                    let statsuTxt = `<li class="list-group-item">Status <span>${data.status}</span></li>
                    <li class="list-group-item">Status Time <span>${data.status_time}</span></li>
                    <li class="list-group-item">Fulfill Type <span class="fulfill_type">${data.fulfill_type.replace(/_/g, ' ')}</span></li>`;
                    $('.status-details-list').html(statsuTxt);

                    if (data.status == 'Shipped') {
                        $(".updatebtn, #input-order-status").addClass('Open');
                    } else {
                        $(".updatebtn").removeClass('Open');
                    }
                    $("#input-order-status").val(data.status);


                    if (data.status == 'ready_for_pickup') {
                        $(".updatebtn").addClass('Open');
                    }



                    let billingTxt = `<li class="list-group-item"> <b>${order_shippingAddress.firstName} ${orders.shippingAddress.lastName}</b></li>
                    <li class="list-group-item">${order_shippingAddress.streetNumber}, ${order_shippingAddress.streetName}, ${order_shippingAddress.city}, ${order_shippingAddress.state},${order_shippingAddress.country} - ${order_shippingAddress.postalCode}</li>`;
                    $('.billing-details-list').html(billingTxt);
                    let shippingTxt = `<li class="list-group-item"> <b>${order_shippingAddress.firstName} ${orders.shippingAddress.lastName}</b></li>
                    <li class="list-group-item">${order_shippingAddress.streetNumber}, ${order_shippingAddress.streetName}, ${order_shippingAddress.city}, ${order_shippingAddress.state},${order_shippingAddress.country} - ${order_shippingAddress.postalCode}</li>`;
                    $('.shipping-details-list').html(shippingTxt);
                    if (typeof(order_lineItems) != "undefined") {
                        var total_amount = 0;
                        var FSR = 0.0;
                        var productTxt = ``;
                        for (let i = 0; i < order_lineItems.length; i++) {
                            let obj = order_lineItems[i];

                      if (typeof obj != "undefined" && obj !=null) {

                            productTxt += `<tr class="product-row product-row-${i}">
                           <td class="text-left"><a href="">${obj.name.en}</a> </td>
                            <td class="text-left">${obj.productId}</td>
                            <td class="text-left product-sku" data-stock="">${obj.variant.sku}</td>
                            // <td class="text-left"></td>
                            <td class="text-right product-quantity">${obj.quantity}</td>
                            <td class="text-right">$`+insertDecimal(obj.price.value.centAmount, obj.price.value.fractionDigits)+`</td>
                            <td class="text-right">$`+insertDecimal(obj.totalPrice.centAmount, obj.totalPrice.fractionDigits)+`</td>
                            
                        </tr>`;
                        }
                    }
                        //var total_order_price = insertDecimal(data[0].order_total);
                        productTxt += `<tr>
                                        <td colspan="6" class="text-right">Sub-Total</td>
                                        <td class="text-right">$ ${order_total}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="6" class="text-right">Flat Shipping Rate</td>
                                        <td class="text-right">$ ${FSR}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="6" class="text-right">Total</td>
                                        <td class="text-right">$ ${order_total}</td>
                                    </tr>`;
                        $('#product-details').html(productTxt);
                        $('#user-name').text(username);
                    }
                } else {}
            }
        });
    }
    let xt = $("#input-order-status").val();
    if (xt == 'Open') {
        $(".updatebtn").addClass('Open');
    } else {
        $(".updatebtn").removeClass('Open');
    }

    // STATUS CODE

    $("#input-order-status").change(function() {
        option = $("#input-order-status").val();
        if (option == 'Open') {
            $(".updatebtn").addClass('Open');
        } else {
            $(".updatebtn").removeClass('Open');
        }
    });

    function get_stock(sku) {
        var dealerId = localStorage.getItem("dealerId");
        let stock = 0;
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/get_inventory/${sku}/${dealerId}`,
            type: "GET",
            async: false,
            success: function(data) {
                console.log(data);
                if (data.length) {
                    stock = data[0].stock;
                }
            }
        });
        return stock;
    }

    $("#update_status").on('click', function() {
        var token = get_accesstoken();
        let getStatus = $("#input-order-status").val();
        if (getStatus == 'Open') {
            $(".updatebtn").addClass('Open');
        }
        if (getStatus == 'ready_for_pickup') {
            pick_from_dealer(getStatus);
            $(".updatebtn").addClass('Open');
        }
        if (getStatus == 'Shipped') {
            var version = getOrderVersion(token);
            Shipped_fn(token, version);
        }
        $(".updatebtn").addClass('Open');
        get_order_details();

    });


    function pick_from_dealer(status) {
   
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/update-dealer_order/${orderId}/${status}`,
            type: "PUT",
            data: {
                "data": {
                    "type": "order",
                    "shipping": "Shipped"
                }
            },
            success: function(data) {
                console.log("data");
                console.log(data);
                $.notify("Ready to pickup - Order Status Update Successfully!!", { className: 'success', showDuration: 400, autoHideDelay: 6000, position: 'right bottom' });

            }
        });
    }

    function update_inventory_products() {
        for (let k = 0; k < $(".product-row").length; k++) {
            let productObj = {};
            var sku = $(`.product-row-${k}`).children('.product-sku').text();
            var quantity= Number($(`.product-row-${k}`).children('.product-quantity').text());
            var dealerid = localStorage.getItem("dealerId");
            console.log("sku---",sku);
            console.log("qty---",quantity);
            console.log("dealerid--",dealerid);
            update_inventory(sku,quantity,dealerid);
            
        }
    }

    function update_inventory(sku,quantity,dealerid) {
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/update_inventory/${sku}/${quantity}/${dealerid}`,
            type: "PUT",
            success: function(data) {
                console.log("data");
                console.log(data);
            },
            error: function(e) {
                console.log(e);
            }
        });
    }
    
    function get_accesstoken() {
        let token = "";
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/createOAuthToken`,
            type: "POST",
            async: false,
            success: function(data) {
                if (data.length) {
                    token = data.access_token;
                }
                console.log(data);
                token = data.access_token;
            }
        });
              return token;
    }

    function Shipped_fn(token,version) {
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/change_shipment_status/${orderId}`,
            type: "POST",
            headers: {
                "accessToken": token
              },
            data: JSON.stringify( {
                "version": version,
                "actions": [
                    {
                        "action" : "changeShipmentState",
                        "shipmentState" : "Shipped"
                      }
                ]
            }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function(response) {
                    update_inventory_products();
                    var version_2 = getOrderVersion(token);
                    Complete_fn(token, version_2); 
            }
        });
    }

    function Complete_fn(token, version) {
         $.ajax({
            url: `http://ctframework.cnetric.com:1880/change_order_status/${orderId}`,
            type: "POST",
            headers: {
                "accessToken": token
              },
            data: JSON.stringify( {
                "version": version,
                "actions": [
                    {
                        "action" : "changeOrderState",
                        "orderState" : "Complete"
                      }
                ]
            }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function(response) {
                console.log(response);
                alert("Completed- Order Status Update Successfully!");
                    location.reload();   
            }
        });
    }
    function insertDecimal(num, decimal) {
        return (num / Math.pow(10, decimal)).toFixed(decimal);
     }

     function getOrderVersion(token ){ 
        var version;
        $.ajax({
            url: `http://ctframework.cnetric.com:1880/getOrder/${orderId}`,
            type: "GET",
            headers: {
                "accessToken": token,
              },
            async: false,
            contentType: "application/json",
            dataType: "json",
            success: function(response) {
                version = response.version;
            }
        });
        return version;
     }
});